/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jtbcore.db.sql.SqlColumn;
import jtbcore.db.sql.SqlTable;

public class SqlDatabase {
    protected Map<String, SqlTable> mapTables = new HashMap<String, SqlTable>();

    public void setTables(List<SqlTable> tables) {
        for (SqlTable t : tables) {
            this.mapTables.put(t.getName().toLowerCase(), t);
        }
    }

    public void addTable(SqlTable t) {
        this.mapTables.put(t.getName().toLowerCase(), t);
    }

    public List<SqlTable> getTables() {
        return new ArrayList<SqlTable>(this.mapTables.values());
    }

    public Boolean hasColumn(String tblName, String colName) {
        if (this.mapTables.containsKey(tblName.toLowerCase()) && this.mapTables.get(tblName.toLowerCase()).getColumn(colName) != null) {
            return true;
        }
        return false;
    }

    public SqlColumn getColumn(String tblName, String colName) {
        if (this.mapTables.containsKey(tblName)) {
            return this.mapTables.get(tblName.toLowerCase()).getColumnByName(colName);
        }
        return null;
    }

    public SqlTable getTable(String tblName) {
        String n = tblName.toLowerCase();
        if (n.indexOf(46) != -1) {
            n = n.substring(n.indexOf(46) + 1);
        }
        return this.mapTables.get(n);
    }

    public boolean hasTable(String tblName) {
        SqlTable tbl = this.getTable(tblName);
        return tbl != null;
    }
}

